<?php
/**
 * Cookie Preferences Modal
 */

// ✅ Inject the Modal into the Footer
function ns_render_cookie_modal_in_footer() {
    // Get the Privacy Policy URL from settings
    $privacy_policy_url = get_option('ns_cookie_policy_url', '/privacy-policy');
    ?>
    <div id="cookie-preferences-modal" class="cookie-modal">
        <p class="cookie-message">
            Този сайт използва бисквитки, за да подобри вашето изживяване. Моля,
            изберете кои типове бисквитки желаете да приемете. За повече информация,
            вижте нашата 
            <a href="<?php echo esc_url($privacy_policy_url); ?>" class="privacy-link">Политика за поверителност</a>.
        </p>
        <div class="cookie-buttons">
            <button id="accept-all-cookies" class="cookie-btn accept">
                Приемете всички
            </button>
            <button id="reject-all-cookies" class="cookie-btn reject">
                Отхвърляне
            </button>
        </div>
    </div>
    <?php
}
add_action('wp_footer', 'ns_render_cookie_modal_in_footer');