<?php
if (!defined('ABSPATH')) exit; // Prevent direct access

// ✅ Register the Cookie Settings
add_action('admin_init', 'register_cookie_settings');

function register_cookie_settings() {
    register_setting(
        'ns_cookie_settings',
        'ns_cookie_policy_url',
        [
            'type' => 'string',
            'sanitize_callback' => 'ns_validate_cookie_policy_url',
            'default' => '/privacy-policy'
        ]
    );

    add_settings_section(
        'ns_cookie_section',
        'Настройки за бисквитки',
        '__return_false',
        'ns-cookie-settings'
    );

    add_settings_field(
        'ns_cookie_policy_url',
        'Линк към Политиката за поверителност',
        'ns_cookie_policy_url_callback',
        'ns-cookie-settings',
        'ns_cookie_section'
    );
}

// ✅ Validation Callback Function for the URL
function ns_validate_cookie_policy_url($url) {
    $url = esc_url_raw(trim($url));

    if (empty($url)) {
        add_settings_error('ns_cookie_policy_url', 'invalid_cookie_policy_url', 'URL не може да бъде празен.');
        return '/privacy-policy';
    }

    return $url;
}

// ✅ Callback function for the Privacy Policy URL
function ns_cookie_policy_url_callback() {
    $value = get_option('ns_cookie_policy_url', '/privacy-policy');
    echo '<input type="url" name="ns_cookie_policy_url" value="' . esc_attr($value) . '" class="regular-text" placeholder="https://example.com/privacy-policy">';
    echo '<p class="description">Въведете URL към вашата Политика за поверителност.</p>';
}
?>