<?php
if (!defined('ABSPATH')) exit; // Prevent direct access

// ✅ Register Newsletter Settings
add_action('admin_init', 'register_newsletter_settings');

function register_newsletter_settings() {
    register_setting('ns_newsletter_settings', 'ns_company_uuid', 'sanitize_text_field');
    register_setting('ns_newsletter_settings', 'ns_newsletter_title', 'sanitize_text_field');
    register_setting('ns_newsletter_settings', 'ns_newsletter_description', 'sanitize_textarea_field');
    register_setting('ns_newsletter_settings', 'ns_newsletter_button_text', 'sanitize_text_field');
    register_setting('ns_newsletter_settings', 'ns_modal_delay', 'intval');
    register_setting('ns_newsletter_settings', 'ns_privacy_policy_url', 'esc_url_raw');
    register_setting('ns_newsletter_settings', 'ns_modal_color', 'sanitize_hex_color'); // ✅ New color setting

    add_settings_section(
        'ns_newsletter_section',
        'Конфигурация на бюлетина',
        '__return_false',
        'ns-newsletter-settings'
    );

    add_settings_field('ns_company_uuid', 'UUID на компанията', 'ns_company_uuid_callback', 'ns-newsletter-settings', 'ns_newsletter_section');
    add_settings_field('ns_newsletter_title', 'Заглавие на бюлетина', 'ns_newsletter_title_callback', 'ns-newsletter-settings', 'ns_newsletter_section');
    add_settings_field('ns_newsletter_description', 'Описание на бюлетина', 'ns_newsletter_description_callback', 'ns-newsletter-settings', 'ns_newsletter_section');
    add_settings_field('ns_newsletter_button_text', 'Текст на бутона', 'ns_newsletter_button_text_callback', 'ns-newsletter-settings', 'ns_newsletter_section');
    add_settings_field('ns_modal_delay', 'Забавяне на показването (секунди)', 'ns_modal_delay_callback', 'ns-newsletter-settings', 'ns_newsletter_section');
    add_settings_field('ns_privacy_policy_url', 'URL на политика за поверителност', 'ns_privacy_policy_url_callback', 'ns-newsletter-settings', 'ns_newsletter_section');
    add_settings_field('ns_modal_color', 'Основен цвят (бутони и линкове)', 'ns_modal_color_callback', 'ns-newsletter-settings', 'ns_newsletter_section'); // ✅ New field
}

// ✅ Callback functions for input fields
function ns_company_uuid_callback() {
    $company_uuid = get_option('ns_company_uuid');
    echo '<input type="text" name="ns_company_uuid" value="' . esc_attr($company_uuid) . '" class="regular-text">';
}

function ns_newsletter_title_callback() {
    $title = get_option('ns_newsletter_title', 'Абонирайте се за нашия бюлетин.');
    echo '<input type="text" name="ns_newsletter_title" value="' . esc_attr($title) . '" class="regular-text">';
}

function ns_newsletter_description_callback() {
    $description = get_option('ns_newsletter_description', 'Ние се грижим за вашите данни.');
    echo '<textarea name="ns_newsletter_description" class="large-text" rows="3">' . esc_textarea($description) . '</textarea>';
}

function ns_newsletter_button_text_callback() {
    $button_text = get_option('ns_newsletter_button_text', 'Абонирай се');
    echo '<input type="text" name="ns_newsletter_button_text" value="' . esc_attr($button_text) . '" class="regular-text">';
}

function ns_modal_delay_callback() {
    $delay = max(1, get_option('ns_modal_delay', 7));
    echo '<input type="number" name="ns_modal_delay" value="' . esc_attr($delay) . '" class="small-text" min="1">';
}

function ns_privacy_policy_url_callback() {
    $privacy_policy_url = get_option('ns_privacy_policy_url', '#');
    echo '<input type="url" name="ns_privacy_policy_url" value="' . esc_attr($privacy_policy_url) . '" class="regular-text">';
}

function ns_modal_color_callback() {
    $color = get_option('ns_modal_color', '#4f46e5'); // ✅ Default color (indigo)
    echo '<input type="text" name="ns_modal_color" value="' . esc_attr($color) . '" class="regular-text" placeholder="#4f46e5">';
}
?>