<?php
// Prevent direct access
if (!defined('ABSPATH')) exit;

// ✅ Inject the Newsletter Modal into the Footer
function ns_render_newsletter_modal_in_footer() {
    $title = get_option('ns_newsletter_title', 'Абонирайте се за нашия бюлетин');
    $description = get_option('ns_newsletter_description', 'Получавайте най-новите новини и актуализации директно във вашата пощенска кутия.');
    $button_text = get_option('ns_newsletter_button_text', 'Абонирай се');
    $company_uuid = get_option('ns_company_uuid', '');
    $privacy_policy_url = get_option('ns_privacy_policy_url', '#');
    $modal_color = get_option('ns_modal_color', '#4f46e5'); // ✅ Get color setting

    echo '<div id="ns-modal-wrapper" class="ns-modal-wrapper hidden">
            <div class="ns-modal-light">
                <div class="ns-modal-light-container">
                    <div class="max-w-xl lg:max-w-lg relative">
                        <!-- ✅ Close Button -->
                        <button id="ns-modal-close" class="ns-modal-close-btn" aria-label="Затвори модала">&times;</button>
                        
                        <h2 class="ns-modal-light-title">' . esc_html($title) . '</h2>
                        <p class="ns-modal-light-description">' . esc_html($description) . '</p>
                        <p class="ns-modal-light-description">
                            <a href="' . esc_url($privacy_policy_url) . '" class="ns-modal-light-link" style="color:' . esc_attr($modal_color) . '; ">
                                Политика за поверителност
                            </a>
                        </p>
                        <div class="ns-modal-light-form">
                            <form id="ns-signup-form" class="ns-modal-light-form-group">
                                <label for="email-address" class="ns-sr-only">Имейл адрес</label>
                                <input id="email-address" name="email" type="email" required 
                                    placeholder="Въведете вашия имейл" autocomplete="email" 
                                    class="ns-modal-light-input">
                                <input type="hidden" id="ns-company-uuid" name="company_uuid" 
                                    value="' . esc_attr($company_uuid) . '">
                                <button type="submit" class="ns-modal-light-button" style="background:' . esc_attr($modal_color) . '; color: white;">
                                    ' . esc_html($button_text) . '
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
          </div>';
}
add_action('wp_footer', 'ns_render_newsletter_modal_in_footer');
?>